% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findOverlap.R
\name{findOverlap}
\alias{findOverlap}
\title{Find overlap between list of windows}
\usage{
findOverlap(owins, centroids = NULL, returnIds = FALSE, numCentroids = 30)
}
\arguments{
\item{owins}{the list of windows}

\item{centroids}{The centroids of the windows}

\item{returnIds}{A boolean, should the indices of the overlap be returned?
If FALSE an error is thrown at the first overlap}

\item{numCentroids}{An integer, the number of cells with closest centroids to consider looking for overlap}
}
\value{
Throws an error when overlap found, otherwise returns invisible.
When returnIds=TRUE, the indices of overlapping windows are returned.
}
\description{
The function seeks overlap between the list of windows supplied,
and throws an error when found or returns the id's when found.
}
\examples{
library(spatstat.geom)
owins <- replicate(10, owin(
    xrange = runif(1) + c(0, 0.2),
    yrange = runif(1) + c(0, 0.1)
), simplify = FALSE)
idOverlap <- findOverlap(owins, returnIds = TRUE)
}
