% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlalomModel-methods.R
\name{updateSlalom}
\alias{updateSlalom}
\title{Update a SlalomModel object}
\usage{
updateSlalom(object)
}
\arguments{
\item{object}{a \code{Rcpp_SlalomModel} object}
}
\value{
an `Rcpp_SlalomModel` object
}
\description{
Do one variational update of a SlalomModel to infer model parameters.
}
\details{
Update the model with one iteration using variational Bayes methods
to infer parameters.
}
\examples{
gmtfile <- system.file("extdata", "reactome_subset.gmt", package = "slalom")
genesets <- GSEABase::getGmt(gmtfile)
data("mesc")
model <- newSlalomModel(mesc, genesets, n_hidden = 5, min_genes = 10)
model <- initSlalom(model)
model <- updateSlalom(model)
}
\author{
Davis McCarthy
}
