% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimCounts.R
\name{trimCounts}
\alias{trimCounts}
\title{Trim Counts}
\usage{
trimCounts(counts, trimValue = c(10, -10))
}
\arguments{
\item{counts}{matrix}

\item{trimValue}{where trimValue[1] for upper threshold and trimValue[2] as
lower threshold. Default is \code{c(10,-10)}}
}
\value{
trimmed counts matrix
}
\description{
Trims an input count matrix such that each value greater than a
threshold value and each value less than a provided
lower threshold value is trimmed to the lower treshold value.
}
\examples{
data(sce_chcl, package = "scds")
assay(sce_chcl, "countsTrimmed") <- trimCounts(assay(sce_chcl, "counts"),
                                               c(10, -10))
}
