% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetSCE.R
\name{subsetSCECols}
\alias{subsetSCECols}
\title{Subset a SingleCellExperiment object by columns}
\usage{
subsetSCECols(inSCE, index = NULL, bool = NULL, colData = NULL)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{index}{Integer vector. Vector of indicies indicating which columns
to keep. If \code{NULL}, this will not be used for subsetting.
Default \code{NULL}.}

\item{bool}{Boolean vector. Vector of \code{TRUE} or \code{FALSE}
indicating which columns should be kept. Needs to be the same length as the
number of columns in \code{inSCE}. If \code{NULL}, this will not be used
for subsetting. Default \code{NULL}.}

\item{colData}{Character. An expression that will identify a subset of
columns using variables found in the \code{colData} of \code{inSCE}.
For example, if \code{x} is a numeric vector in \code{colData},
then \code{"x < 5"} will return all columns with x less than 5.
Single quotes should be used for character strings. For example,
\code{"y == 'yes'"} will return all columns where y is "yes".
Multiple expressions can be evaluated by placing them in a vector.
For example \code{c("x < 5", "y =='yes'")} will apply both operations for
subsetting. If \code{NULL}, this will not be used for subsetting.
Default \code{NULL}.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object that has
been subsetted by colData.
}
\description{
Used to peform subsetting of a
\linkS4class{SingleCellExperiment} object using a variety of methods that
indicate the correct columns to keep. The various methods,
\code{index}, \code{bool}, and \code{colData}, can be used in conjunction
with one another.
}
\examples{
data(scExample)
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
}
\author{
Joshua D. Campbell
}
