% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleSummaryStats.R
\name{sampleSummaryStats}
\alias{sampleSummaryStats}
\title{Generate table of SCTK QC outputs.}
\usage{
sampleSummaryStats(
  inSCE,
  sample = NULL,
  useAssay = "counts",
  simple = TRUE,
  statsName = "qc_table"
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object with saved
\link{assay} data and/or \link{colData} data. Required.}

\item{sample}{Character vector. Indicates which sample each cell belongs to.}

\item{useAssay}{A string specifying which assay in the SCE to use. Default
'counts'.}

\item{simple}{Boolean. Indicates whether to generate a table of only
basic QC stats (ex. library size), or to generate a summary table of all
QC stats stored in the inSCE.}

\item{statsName}{Character. The name of the slot that will store the
QC stat table. Default "qc_table".}
}
\value{
A SingleCellExperiment object with a summary table for QC statistics
in the `sample_summary` slot of metadata.
}
\description{
Creates a table of QC metrics generated from
 QC algorithms, which is stored within the metadata slot of the
 input SingleCellExperiment object.
}
\examples{
data(scExample, package = "singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
sce <- sampleSummaryStats(sce, simple = TRUE)
getSampleSummaryStatsTable(sce, statsName = "qc_table")
}
