% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{runScanpyPCA}
\alias{runScanpyPCA}
\title{runScanpyPCA
Computes PCA on the input sce object and stores the calculated principal
components within the sce object}
\usage{
runScanpyPCA(
  inSCE,
  useAssay = "scanpyScaledData",
  reducedDimName = "scanpyPCA",
  nPCs = 50,
  method = c("arpack", "randomized", "auto", "lobpcg"),
  use_highly_variable = TRUE,
  seed = 12345
)
}
\arguments{
\item{inSCE}{(sce) object on which to compute PCA}

\item{useAssay}{Assay containing scaled counts to use in PCA. Default
\code{"scanpyScaledData"}.}

\item{reducedDimName}{Name of new reducedDims object containing Scanpy PCA.
Default \code{scanpyPCA}.}

\item{nPCs}{numeric value of how many components to compute. Default
\code{50}.}

\item{method}{selected method to use for computation of pca. 
One of \code{'arpack'}, \code{'randomized'}, \code{'auto'} or \code{'lobpcg'}.
Default \code{"arpack"}.}

\item{use_highly_variable}{boolean value of whether to use highly variable 
genes only. By default uses them if they have been determined beforehand.}

\item{seed}{Specify numeric value to set as a seed. Default \code{12345}.}
}
\value{
Updated \code{SingleCellExperiment} object which now contains the
computed principal components
}
\description{
runScanpyPCA
Computes PCA on the input sce object and stores the calculated principal
components within the sce object
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
}
}
