% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSingleCellMatrix.R
\name{readSingleCellMatrix}
\alias{readSingleCellMatrix}
\title{Read single cell expression matrix}
\usage{
readSingleCellMatrix(
  file,
  class = c("Matrix", "matrix"),
  delayedArray = TRUE,
  colIndexLocation = NULL,
  rowIndexLocation = NULL
)
}
\arguments{
\item{file}{Path to input file. Supported file endings include .mtx, .txt,
.csv, .tab, .tsv, .npz, and their corresponding \code{gzip},
\code{bzip2}, or \code{xz} compressed extensions (\code{*.gz},
\code{*.bz2}, or \code{*.xz}).}

\item{class}{Character. Class of matrix. One of "Matrix" or "matrix". Specifying "Matrix"
will convert to a sparse format which should be used
for datasets with large numbers of cells.  Default "Matrix".}

\item{delayedArray}{Boolean. Whether to read the expression matrix as
\link{DelayedArray} object or not. Default \code{TRUE}.}

\item{colIndexLocation}{Character. For Optimus output, the path to the
barcode index .npy file. Used only if \code{file} has .npz extension.
Default \code{NULL}.}

\item{rowIndexLocation}{Character. For Optimus output, The path to the
feature (gene) index .npy file. Used only if \code{file} has .npz extension.
Default \code{NULL}.}
}
\value{
A \link{DelayedArray} object or matrix.
}
\description{
Automatically detact the format of the input file and read
 the file.
}
\examples{
mat <- readSingleCellMatrix(system.file("extdata/hgmm_1k_v3_20x20/outs/",
    "filtered_feature_bc_matrix/matrix.mtx.gz", package = "singleCellTK"))
}
