% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runTSCAN.R
\name{plotTSCANDimReduceFeatures}
\alias{plotTSCANDimReduceFeatures}
\title{Plot feature expression on cell 2D embedding with MST overlaid}
\usage{
plotTSCANDimReduceFeatures(
  inSCE,
  features,
  useReducedDim = "UMAP",
  useAssay = "logcounts",
  by = "rownames",
  useCluster = NULL,
  featureDisplay = metadata(inSCE)$featureDisplay,
  combinePlot = c("all", "none")
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{features}{Choose the feature of interest to explore the expression
level on the trajectory. Required.}

\item{useReducedDim}{A single character for the matrix of 2D embedding.
Should exist in \code{reducedDims} slot. Default \code{"UMAP"}.}

\item{useAssay}{A single character for the feature expression matrix. Should
exist in \code{assayNames(inSCE)}. Default \code{"logcounts"}.}

\item{by}{Where should \code{features} be found? \code{NULL},
\code{"rownames"} for \code{rownames(inSCE)}, otherwise will be regarded as
\code{rowData} variable.}

\item{useCluster}{Choose specific clusters where gene expression needs to be
visualized. By default \code{NULL}, all clusters are chosen.}

\item{featureDisplay}{Specify the feature ID type to display. Users can set
default value with \code{\link{setSCTKDisplayRow}}. \code{NULL} or
\code{"rownames"} specifies the rownames of \code{inSCE}. Other character
values indicates \code{rowData} variable.}

\item{combinePlot}{Must be either \code{"all"} or \code{"none"}. \code{"all"}
will combine plots of each feature into a single \code{.ggplot} object,
while \code{"none"} will output a list of plots. Default \code{"all"}.}
}
\value{
A \code{.ggplot} object of cell scatter plot, colored by the
expression of a gene of interest, with the layer of trajectory.
}
\description{
A wrapper function which plots all cells or cells in chosen
cluster. Each point is a cell colored by the expression of a feature of
interest, the relevant edges of the MST are overlaid on top.
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
mouseBrainSubsetSCE <- runTSCAN(inSCE = mouseBrainSubsetSCE,
                                useReducedDim = "PCA_logcounts")
plotTSCANDimReduceFeatures(inSCE = mouseBrainSubsetSCE,
                           features = "Tshz1",
                           useReducedDim = "TSNE_logcounts")
}
\author{
Yichen Wang
}
