% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPlotting.R
\name{plotSCEScatter}
\alias{plotSCEScatter}
\title{Dimension reduction plot tool for all types of data}
\usage{
plotSCEScatter(
  inSCE,
  annotation,
  reducedDimName = NULL,
  slot = NULL,
  sample = NULL,
  feature = NULL,
  groupBy = NULL,
  shape = NULL,
  conditionClass = NULL,
  xlab = NULL,
  ylab = NULL,
  axisSize = 10,
  axisLabelSize = 10,
  dim1 = NULL,
  dim2 = NULL,
  bin = NULL,
  binLabel = NULL,
  dotSize = 0.1,
  transparency = 1,
  colorLow = "white",
  colorMid = "gray",
  colorHigh = "blue",
  defaultTheme = TRUE,
  title = NULL,
  titleSize = 15,
  labelClusters = TRUE,
  legendTitle = NULL,
  legendTitleSize = 12,
  legendSize = 10,
  combinePlot = "none",
  plotLabels = NULL
)
}
\arguments{
\item{inSCE}{Input SingleCellExperiment object with saved dimension reduction
components or a variable with saved results. Required.}

\item{annotation}{Desired vector within the slot used for plotting. Default NULL.}

\item{reducedDimName}{saved dimension reduction name in the
\linkS4class{SingleCellExperiment} object.}

\item{slot}{Desired slot of SingleCellExperiment used for plotting. Possible
options: "assays", "colData", "metadata", "reducedDims". Default NULL.}

\item{sample}{Character vector. Indicates which sample each cell belongs to.}

\item{feature}{name of feature stored in assay of SingleCellExperiment
object. Will be used only if "assays" slot is chosen. Default NULL.}

\item{groupBy}{Group by a condition(any column of the annotation data).
Default NULL.}

\item{shape}{add shapes to each condition.}

\item{conditionClass}{class of the annotation data used in colorBy. Options
are NULL, "factor" or "numeric". If NULL, class will default to the original
class. Default NULL.}

\item{xlab}{Character vector. Label for x-axis. Default NULL.}

\item{ylab}{Character vector. Label for y-axis. Default NULL.}

\item{axisSize}{Size of x/y-axis ticks. Default 10.}

\item{axisLabelSize}{Size of x/y-axis labels. Default 10.}

\item{dim1}{1st dimension to be used for plotting. Can either be a string which specifies
the name of the dimension to be plotted from reducedDims, or a numeric value which specifies
the index of the dimension to be plotted. Default is NULL.}

\item{dim2}{2nd dimension to be used for plotting. Can either be a string which specifies
the name of the dimension to be plotted from reducedDims, or a numeric value which specifies
the index of the dimension to be plotted. Default is NULL.}

\item{bin}{Numeric vector. If single value, will divide the numeric values into the `bin` groups.
If more than one value, will bin numeric values using values as a cut point.}

\item{binLabel}{Character vector. Labels for the bins created by the `bin` parameter.
Default NULL.}

\item{dotSize}{Size of dots. Default 0.1.}

\item{transparency}{Transparency of the dots, values will be 0-1. Default 1.}

\item{colorLow}{Character. A color available from `colors()`.
The color will be used to signify the lowest values on the scale.
Default 'white'.}

\item{colorMid}{Character. A color available from `colors()`.
The color will be used to signify the midpoint on the scale.
Default 'gray'.}

\item{colorHigh}{Character. A color available from `colors()`.
The color will be used to signify the highest values on the scale.
Default 'blue'.}

\item{defaultTheme}{adds grid to plot when TRUE. Default TRUE.}

\item{title}{Title of plot. Default NULL.}

\item{titleSize}{Size of title of plot. Default 15.}

\item{labelClusters}{Logical. Whether the cluster labels are plotted.}

\item{legendTitle}{title of legend. Default NULL.}

\item{legendTitleSize}{size of legend title. Default 12.}

\item{legendSize}{size of legend. Default 10.}

\item{combinePlot}{Must be either "all", "sample", or "none". "all" will combine all plots into a single
.ggplot object, while "sample" will output a list of plots separated by sample. Default "none".}

\item{plotLabels}{labels to each plot. If set to "default", will use the name of the samples
as the labels. If set to "none", no label will be plotted.}
}
\value{
a ggplot of the reduced dimensions.
}
\description{
Plot results of reduced dimensions data of counts stored in any
slot in the SingleCellExperiment object.
}
\examples{
data("mouseBrainSubsetSCE")
plotSCEScatter(
  inSCE = mouseBrainSubsetSCE, legendTitle = NULL,
  slot = "assays", annotation = "counts", feature = "Apoe",
  reducedDimName = "TSNE_counts", labelClusters = FALSE
)
}
