% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportSCEtoTXT.R
\name{exportSCEtoFlatFile}
\alias{exportSCEtoFlatFile}
\title{Export a \link[SingleCellExperiment]{SingleCellExperiment} object to flat text files}
\usage{
exportSCEtoFlatFile(
  sce,
  outputDir = "./",
  overwrite = TRUE,
  gzipped = TRUE,
  prefix = "SCE"
)
}
\arguments{
\item{sce}{\link[SingleCellExperiment]{SingleCellExperiment} object to be
exported.}

\item{outputDir}{Name of the directory to store the exported file(s).}

\item{overwrite}{Boolean. Whether to overwrite the output files. Default
\code{TRUE}.}

\item{gzipped}{Boolean. \code{TRUE} if the output files are to be
gzip compressed. \code{FALSE} otherwise. Default
\code{TRUE}.}

\item{prefix}{Prefix of file names.}
}
\value{
Generates text files containing data from \code{inSCE}.
}
\description{
Writes all assays, colData, rowData, reducedDims, and altExps objects in a
\link[SingleCellExperiment]{SingleCellExperiment} to text files.
The items in the 'metadata' slot remain stored in list and are saved in an RDS file.
}
\examples{
data(sce_chcl, package = "scds")
\dontrun{
exportSCEtoFlatFile(sce_chcl, "sce_chcl")
}
}
