% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropletUtils_barcodeRank.R
\name{runBarcodeRankDrops}
\alias{runBarcodeRankDrops}
\title{Identify empty droplets using \link[DropletUtils]{barcodeRanks}.}
\usage{
runBarcodeRankDrops(
  inSCE,
  sample = NULL,
  useAssay = "counts",
  lower = 100,
  fitBounds = NULL,
  df = 20
)
}
\arguments{
\item{inSCE}{A \linkS4class{SingleCellExperiment} object. Must contain a raw 
counts matrix before empty droplets have been removed.}

\item{sample}{Character vector or colData variable name. Indicates which 
sample each cell belongs to. Default \code{NULL}.}

\item{useAssay}{A string specifying which assay in the SCE to use. Default 
\code{"counts"}}

\item{lower}{See \link[DropletUtils]{barcodeRanks} for more information. 
Default \code{100}.}

\item{fitBounds}{See \link[DropletUtils]{barcodeRanks} for more information. 
Default \code{NULL}.}

\item{df}{See \link[DropletUtils]{barcodeRanks} for more information. Default 
\code{20}.}
}
\value{
A \linkS4class{SingleCellExperiment} object with the
\link[DropletUtils]{barcodeRanks} output table appended to the
\link{colData} slot. The columns include
\code{dropletUtils_BarcodeRank_Knee} and 
\code{dropletUtils_barcodeRank_inflection}. Please refer to the documentation
of \link[DropletUtils]{barcodeRanks} for details.
}
\description{
Run \link[DropletUtils]{barcodeRanks} on a count matrix
provided in a \linkS4class{SingleCellExperiment} object. Distinguish between 
droplets containing cells and ambient RNA in a droplet-based single-cell RNA 
sequencing experiment.
}
\examples{
data(scExample, package = "singleCellTK")
sce <- runBarcodeRankDrops(inSCE = sce)
}
\seealso{
\code{\link[DropletUtils]{barcodeRanks}}, 
\code{\link{runDropletQC}}, \code{\link{plotBarcodeRankDropsResults}}
}
