% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{plotScanpyPCA}
\alias{plotScanpyPCA}
\title{plotScanpyPCA}
\usage{
plotScanpyPCA(
  inSCE,
  reducedDimName = "scanpyPCA",
  color = NULL,
  title = "",
  legend = "right margin"
)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{reducedDimName}{Name of new reducedDims object containing Scanpy PCA.}

\item{color}{Keys for annotations of observations/cells or variables/genes.}

\item{title}{Provide title for panels either as string or list of strings}

\item{legend}{Location of legend, either 'on data', 'right margin' or a 
valid keyword for the loc parameter of Legend.}
}
\value{
plot object
}
\description{
plotScanpyPCA
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
plotScanpyPCA(sce)
}
}
