% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPerQCWrapper.R
\name{plotRunPerCellQCResults}
\alias{plotRunPerCellQCResults}
\title{Plots for runPerCellQC outputs.}
\usage{
plotRunPerCellQCResults(
  inSCE,
  sample = NULL,
  groupBy = NULL,
  combinePlot = "all",
  violin = TRUE,
  boxplot = FALSE,
  dots = TRUE,
  dotSize = 0.5,
  summary = "median",
  summaryTextSize = 3,
  baseSize = 15,
  axisSize = NULL,
  axisLabelSize = NULL,
  transparency = 1,
  defaultTheme = TRUE,
  titleSize = NULL,
  relHeights = 1,
  relWidths = 1,
  labelSamples = TRUE,
  plotNCols = NULL,
  plotNRows = NULL,
  samplePerColumn = TRUE,
  sampleRelHeights = 1,
  sampleRelWidths = 1
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object with saved
dimension reduction components or a variable with saved results from
\code{\link{runPerCellQC}}. Required.}

\item{sample}{Character vector or colData variable name. Indicates which
sample each cell belongs to. Default \code{NULL}.}

\item{groupBy}{Groupings for each numeric value. Users may input a vector
equal length to the number of the samples in \code{inSCE}, or can be
retrieved from the colData slot. Default \code{NULL}.}

\item{combinePlot}{Must be either \code{"all"}, \code{"sample"}, or
\code{"none"}. \code{"all"} will combine all plots into a single ggplot
object, while \code{"sample"} will output a list of plots separated by
sample. Default \code{"all"}.}

\item{violin}{Boolean. If \code{TRUE}, will plot the violin plot. Default
\code{TRUE}.}

\item{boxplot}{Boolean. If \code{TRUE}, will plot boxplots for each violin
plot. Default \code{FALSE}.}

\item{dots}{Boolean. If \code{TRUE}, will plot dots for each violin plot.
Default \code{TRUE}.}

\item{dotSize}{Size of dots. Default \code{0.5}.}

\item{summary}{Adds a summary statistic, as well as a crossbar to the
violin plot. Options are \code{"mean"} or \code{"median"}. Default
\code{"median"}.}

\item{summaryTextSize}{The text size of the summary statistic displayed
above the violin plot. Default \code{3}.}

\item{baseSize}{The base font size for all text. Default \code{15}.
Can be overwritten by \code{titleSize}, \code{axisSize}, and
\code{axisLabelSize}.}

\item{axisSize}{Size of x/y-axis ticks. Default \code{NULL}.}

\item{axisLabelSize}{Size of x/y-axis labels. Default \code{NULL}.}

\item{transparency}{Transparency of the dots, values will be 0-1. Default \code{1}.}

\item{defaultTheme}{Removes grid in plot and sets axis title size to
\code{10} when \code{TRUE}. Default \code{TRUE}.}

\item{titleSize}{Size of title of plot. Default \code{NULL}.}

\item{relHeights}{Relative heights of plots when combine is set. Default
\code{1}.}

\item{relWidths}{Relative widths of plots when combine is set. Default
\code{1}.}

\item{labelSamples}{Will label sample name in title of plot if \code{TRUE}.
Default \code{TRUE}.}

\item{plotNCols}{Number of columns when plots are combined in a grid. Default
\code{NULL}.}

\item{plotNRows}{Number of rows when plots are combined in a grid. Default
\code{NULL}.}

\item{samplePerColumn}{If \code{TRUE}, when there are multiple samples and
combining by \code{"all"}, the output .ggplot will have plots from each
sample on a single column. Default \code{TRUE}.}

\item{sampleRelHeights}{If there are multiple samples and combining by
\code{"all"}, the relative heights for each plot. Default \code{1}.}

\item{sampleRelWidths}{If there are multiple samples and combining by
\code{"all"}, the relative widths for each plot. Default \code{1}.}
}
\value{
list of .ggplot objects
}
\description{
A wrapper function which visualizes outputs from the
 runPerCellQC function stored in the colData slot of the SingleCellExperiment
 object via various plots.
}
\examples{
data(scExample, package = "singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
sce <- runPerCellQC(sce)
plotRunPerCellQCResults(inSCE = sce)
}
\seealso{
\code{\link{runPerCellQC}}
}
