% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccc-all-GeneSetPulls.R
\name{setGeneSetsCelltype}
\alias{setGeneSetsCelltype}
\title{Set gene sets per cell type in a superpathway}
\usage{
setGeneSetsCelltype(object, value = NULL, ...)
}
\arguments{
\item{object}{List. A superpathway object created by create_superpathway(), or
a pathway object created by create_pathway().}

\item{value}{List. A list of genes to incorporate in each cell type slot. By
default \code{NULL}, only use if genes are to be introduced manually.}

\item{...}{other parameters to pass onto pullGeneSet().}
}
\value{
The updated superpathway object (list).
}
\description{
Updates the gene_sets_celltype element of a superpathway object,
ensuring validity:
\itemize{
\item The number of gene sets must match the number of cell types.
}
}
\examples{
my_pathway <- create_pathway(
  standard_name = "KEGG_CYTOKINE_CYTOKINE_RECEPTOR_INTERACTION",
  dbsource = "KEGG",
  collection = "c2",
  subcollection = "CP"
)

my_superpathway <- create_superpathway(my_pathway, c("T-cell",
"Dendritic Cell"), list())
\donttest{
my_superpathway <- setGeneSetsCelltype(my_superpathway, list(c("IL2"),
c("IL4")))}
}
