% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{restore_removed_columns}
\alias{restore_removed_columns}
\title{Restore columns removed during MFA cleaning into the imputed matrix}
\usage{
restore_removed_columns(X_imp_clean, X_raw, keep_cols)
}
\arguments{
\item{X_imp_clean}{Numeric matrix (n_samples × p_cleaned) of imputed values
for the columns that were kept.}

\item{X_raw}{Numeric matrix or data.frame (n_samples × p_oril) of ginathe
original predictor data before cleaning.}

\item{keep_cols}{Logical vector of length \code{p_original}, where
\code{TRUE} indicates the column was kept for imputation and
\code{FALSE} indicates it was removed.}
}
\value{
A numeric matrix (n_samples × p_original) with all original columns
in their original order. Columns where \code{keep_cols == TRUE} contain
the values from \code{X_imp_clean}. Columns where
\code{keep_cols == FALSE} contain the original non‐NA values, and any
entries that were originally NA are set to zero.
}
\description{
After cleaning and imputing a subset of predictors (removing any
columns with zero variance or 100\% missing), this function re‐inserts those
removed columns in their original order. For each re‐inserted column,
original non‐missing values are kept and entries that were originally missing
are set to zero.
}
