% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccc-all-GeneSetPulls.R
\name{pullGeneSet}
\alias{pullGeneSet}
\title{Pull Gene Set from MsigDB}
\usage{
pullGeneSet(object, gse = NULL, ...)
}
\arguments{
\item{object}{List. A pathway (from create_pathway()) or superpathway (from create_superpathway()).}

\item{gse}{Gene Set Collection from MsigDB. If NULL, loads default (human, ENTREZ + SYM IDs).}

\item{...}{Additional arguments passed to msigdb::subsetCollection().}
}
\value{
A character vector with gene IDs for the specified pathway.
}
\description{
Retrieves the gene set associated with a pathway or superpathway from MsigDB.
}
\examples{
\donttest{
my_pathway <- create_pathway("KEGG_CYTOKINE_CYTOKINE_RECEPTOR_INTERACTION",
"KEGG", "c2", "CP")
pullGeneSet(my_pathway)}
}
