% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbb-step1-fit.R
\name{permut_asmbplsda_kcv}
\alias{permut_asmbplsda_kcv}
\title{Permutation test for asmbPLS-DA global significance (LOO or KCV)}
\usage{
permut_asmbplsda_kcv(
  object,
  npermut = 100,
  splits = NULL,
  measure = "B_accuracy",
  nbObsPermut = NULL,
  Nc = 1,
  Method = NULL,
  maxiter = 100,
  CV_error = NULL,
  ...
)
}
\arguments{
\item{object}{A superpathway fit model list}

\item{npermut}{Number of permutations (default: 100)}

\item{splits}{Optional list of splits; if NULL uses LOOCV branch}

\item{measure}{Accuracy measure (\code{"F1"}, \code{"accuracy"}, \code{"B_accuracy"},
\code{"precision"}, \code{"recall"}, default: \code{"B_accuracy"}).}

\item{nbObsPermut}{Number of samples to permute per iteration
(default: NULL).}

\item{Nc}{Number of samples dropped per permutation (default: 1 if LOOCV).}

\item{Method}{Decision rule for prediction (default: NULL).}

\item{maxiter}{Maximum iterations (default: 100).}

\item{CV_error}{Error obtained from optimal model CV process}

\item{...}{Other args passed to LOOCV or to evaluate_performance}
}
\value{
A list with null distribution, p-value, and (for KCV) splits
}
\description{
If \code{splits=NULL}, runs LOOCV‐based permutation. Otherwise treats \code{splits} as
a list of train/validate splits (e.g. from make_splits_R()) and does a fixed
splits K‐fold×repeats permutation test.
}
