% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-wrappers.R
\name{multiple_singISTrecapitulations}
\alias{multiple_singISTrecapitulations}
\title{Compute singIST recapitulations for multiple superpathways}
\usage{
multiple_singISTrecapitulations(
  object,
  model_object = list(),
  model_species = list("hsapiens"),
  ...
)
}
\arguments{
\item{object}{A mapping organism list}

\item{model_object}{A list whose elements
are superpathway fit model list}

\item{model_species}{A list of characters indicating the organism of each
\code{model_object} element. By default \code{list("hsapiens")} which assumes the same
organism across all elements of \code{model_object} parameter}

\item{...}{Other parameters to pass onto \link{biological_link_function}}
}
\value{
A list with the row binded \code{data.frame} for each superpathway assessed for
the superpathway and cell type recapitulations, and gene contributions
to the former.
}
\description{
Use \link{singISTrecapitulations} for multiple
superpathway fit model list against the same
mapping organism list. This wrapper is useful if one wants
to assess multiple superpathways against the same
mapping organism list.
}
\examples{
\donttest{file <- system.file("extdata", "example_superpathway_input.rda",
package = "singIST")
load(file)
data_model <- example_superpathway_input
models <- list(data_model, data_model)
# Example with different options
multiple_model <- multiple_fitOptimal(models, type = c("jackknife",
"subsampling"), nsubsampling = c(NULL, 10), npermut = c(10,15))
file <- system.file("extdata", "example_mapping_organism.rda",
package = "singIST")
load(file)
data_organism <- example_mapping_organism
multiple_singISTrecapitulations(data_organism, multiple_model,
model_species = list("hsapiens", "hsapiens"))}
}
