% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step2-biologicalLink.R
\name{diff_expressed}
\alias{diff_expressed}
\title{Compute differentially expressed genes with FindMarkers/findMarkers
and descriptive point estimates of log2FC}
\usage{
diff_expressed(
  object,
  condition_1 = c(),
  condition_2 = c(),
  logfc.treshold = 0.25,
  assay = "RNA",
  ...
)
}
\arguments{
\item{object}{A mapping organism list. If a \code{Seurat} object
was provided, then \code{Idents(object)} assigned to variables with the conditions
being tested is expected.}

\item{condition_1}{A vector with the elements of the first factor to perform
the hypothesis test. By default the mapped cell types
\code{condition_1 = names(object$celltype_mapping)}}

\item{condition_2}{A vector with the elements of the second factor to perform
the hypothesis test with. By default the class of the organism
\verb{condition_2 = c(object$target_class), object$base_class)}}

\item{logfc.treshold}{Sets the minimum FindMarkers log-fold change (logFC)
cutoff for identifying differentially expressed genes (DEGs). By default
\code{logfc.treshold = 0.25}.}

\item{assay}{Specific assay being used for analysis. By default
\code{assay = RNA}.}

\item{...}{Other parameters to pass onto \code{Seurat::FindMarkers()} or
\code{scran::findMarkers}.}
}
\value{
A list where each element is a data.frame for a cell type containing: \code{p_val}
p-value of test, \code{avg_log2FC} descriptive point estimate of logFC,
\code{pct.1} percentage of cells where the gene is detected in the base class,
\code{pct.2} percentage of cells where the gene is detected in the target class,
\code{p_val_adj} FDR.
}
\description{
Computes differentially expressed genes with \code{Seurat::FindMarkers}, for
\code{Seurat} objects, or \code{scran::findMarkers}, for \code{SingleCellExperiment}
objects, for the conditions indicated. Note that \code{Seurat::FindMarkers} will
compute Wilcoxon Signed Rank Test by default, while \code{scran::findMarkers} will
perform t-test by default instead. The reported logFC values are difference
of means of log-normalized expression values with
\code{Seurat::AggregateExpression} or
\code{SingleCellExperiment::aggregateAcrossCells}. This logFC is consistent with
the human log2FC computation by asmbPLS-DA.
}
\examples{
# Set the identities
file <- system.file("extdata", "example_mapping_organism.rda",
package = "singIST")
load(file)
data_organism <- example_mapping_organism
data <- celltype_mapping(data_organism)
data$counts$test <- paste0(data$counts$celltype_cluster, "_",
data$counts$class)
SeuratObject::Idents(data$counts) <- "test"
diff_expressed(data)
}
