% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-all-input.R
\name{create_superpathway}
\alias{create_superpathway}
\title{Create superpathway gene sets object}
\usage{
create_superpathway(pathway_info, celltypes, gene_sets_celltype)
}
\arguments{
\item{pathway_info}{List. A pathway object created by create_pathway().}

\item{celltypes}{Character vector. Each element represents a cell type.}

\item{gene_sets_celltype}{List of character vectors. Each element corresponds
to gene sets for each cell type. Can be NULL.}
}
\value{
A list with elements: pathway_info, celltypes, gene_sets_celltype.
}
\description{
Creates a simple list representing a superpathway, after validating its fields.
}
\examples{
my_pathway <- create_pathway("KEGG_CYTOKINE_CYTOKINE_RECEPTOR_INTERACTION",
"KEGG", "c2", "CP")
my_superpathway <- create_superpathway(my_pathway, c("T-cell",
"Dendritic Cell"), list(c("IL4", "IL5"), c("IL13")))
print(my_superpathway)
}
