% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-all-input.R
\name{create_hyperparameters}
\alias{create_hyperparameters}
\title{Create asmbPLS-DA hyperparameters object}
\usage{
create_hyperparameters(
  quantile_comb_table,
  outcome_type,
  number_PLS,
  folds_CV = 5L,
  repetition_CV = 10L
)
}
\arguments{
\item{quantile_comb_table}{Matrix. Quantile (lambda) sparsity values for CV.}

\item{outcome_type}{Character. Either "binary" or "multiclass".}

\item{number_PLS}{Integer. Maximum number of PLS components.}

\item{folds_CV}{Integer or NULL. Number of folds for CV (default 5).}

\item{repetition_CV}{Integer or NULL. Number of repetitions for CV (default 10).}
}
\value{
A list with elements: quantile_comb_table, outcome_type, number_PLS, folds_CV, repetition_CV.
}
\description{
Creates a simple list representing hyperparameters for asmbPLS-DA, after validating them.
}
\examples{
quantile_comb_table <- base::as.matrix(RcppAlgos::permuteGeneral(seq(0.05,
0.95, by = 0.50)))
my_hyperparameters <- create_hyperparameters(quantile_comb_table,"binary",3L,
1L, 1L)
print(my_hyperparameters)
}
