% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{clean_mfa_data}
\alias{clean_mfa_data}
\title{Clean a predictor matrix for multiblock MFA}
\usage{
clean_mfa_data(X)
}
\arguments{
\item{X}{A numeric matrix or data.frame of predictors (samples × features).}
}
\value{
A list with components:
\describe{
\item{\code{X_clean}}{Cleaned matrix (only kept columns).}
\item{\code{keep_cols}}{Logical vector, \code{TRUE} for columns kept.}
\item{\code{removed}}{Integer indices of removed columns.}
}
}
\description{
Converts non‐finite values to NA, removes any column that is
100\% NA or has zero variance, and returns a logical mask of kept columns.
}
\examples{
clean_mfa_data(matrix(matrix(c(0,0,0,NA, 1,2), ncol = 2, nrow = 3)))
}
