% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step2-biologicalLink.R
\name{biological_link_function}
\alias{biological_link_function}
\title{Biological link function}
\usage{
biological_link_function(
  object,
  model_object,
  object_gene_identifiers = "external_gene_name",
  model_species = "hsapiens",
  FC_list = NULL,
  ...
)
}
\arguments{
\item{object}{A mapping organism list with the disease model data}

\item{model_object}{A superpathway fit model list with the fitted model}

\item{object_gene_identifiers}{Annotation of gene identifiers used in
\code{object}. By default \code{external_gene_name}. If \code{NULL} \link{orthology_mapping}
infers the gene identifiers of \code{object}, note this may add execution time.}

\item{model_species}{Organism for which \code{model_object} has been trained. By
\code{default} \code{hsapiens}.}

\item{FC_list}{Optional parameter with list of matrices containing Fold
Changes provided by the user. If such list is provided, logFC will not be
computed via \link{diff_expressed} and the list input will be used instead.
The list length must match the number and order of human cell types modelled.
Each element of the list must be a \code{data.frame} whose columns are:
"p_value" p-value of test, "avg_log2FC" the log2FC provided, "pct.1" percent
of cells where the gene is expressed in base class, "pct.2" percent of cells
where the gene is expressed in target class, "p_val_adj" adjusted p-value.
Rownames should contain the gene names. Note that log2FC provided should be
comparable to log2FC computed in asmbPLS-DA model. log2FC should be reported
as descriptive point estimates of mean difference of log2 normalized
expression values.}

\item{...}{Other parameters to pass onto \link{diff_expressed}}
}
\value{
A list with; ortholog gene sets as returned by \link{orthology_mapping};
a list with the Fold Changes used; singIST treated samples as returned by
\link{singIST_treat}
}
\description{
Maps the organism information in mapping organism list and
superpathway fit model list to obtain the "singIST treated samples"
with the simulated human. The biological link function involves the
cell type mapping, orthology mapping and fold change computation.
}
\examples{
file <- system.file("extdata", "example_mapping_organism.rda",
package = "singIST")
load(file)
data_organism <- example_mapping_organism
file <- system.file("extdata", "example_superpathway_fit_model.rda",
package = "singIST")
load(file)
data_model <- example_superpathway_fit_model
\donttest{biological_link_function(data_organism, data_model)}
}
