#' @title A superpathway input example
#'
#' @name example_superpathway_input-data
#'
#' @description
#' A superpathway input object containing toy superpathway to run examples
#' of singIST library
#'
#' @usage data(example_superpathway_input)
#' @docType data
#'
#' @format A \link{superpathway.input-class} object
"example_superpathway_input"

#' @title A superpathway fit model example
#'
#' @name example_superpathway_fit_model-data
#'
#' @description
#' A superpathway input object containing toy superpathway to run examples
#' of singIST library
#'
#' @usage data(example_superpathway_fit_model)
#' @docType data
#'
#' @format A \link{superpathway.fit.model-class} object
"example_superpathway_fit_model"

#' @title A mapping organism object example
#'
#' @name example_mapping_organism-data
#'
#' @description
#' A mapping organism object to run examples. Note that the lognormalized
#' count matrix is generated from SeuratObject::pbmc_small toy dataset
#'
#' @usage data(example_mapping_organism)
#' @docType data
#'
#' @format A \link{superpathway.fit.model-class} object
"example_mapping_organism"

#' @title Human pseudobulked matrix of Dendritic Cells in Regulating Th1/Th2
#' Development BIOCARTA pathway
#'
#' @name DC_counts-data
#'
#' @description
#' Pseudobulk lognormalized matrix with the Human expression of Dendritic Cells
#' in Regulating Th1/Th2 Development BIOCARTA pathway.
#'
#' @usage data(DC_counts)
#' @docType data
#'
#' @format A matrix object
"DC_counts"

#' @title Human pseudobulked matrix of Cytokine-Cytokine receptor interaction
#' KEGG pathway
#'
#' @name cytokine_counts-data
#'
#' @description
#' Pseudobulk lognormalized matrix with the Human expression of
#' Cytokine-Cytokine receptor interaction KEGG pathway
#'
#' @usage data(cytokine_counts)
#' @docType data
#'
#' @format A matrix object
"cytokine_counts"

#' @title Seurat object with Oxazolone murine model data
#'
#' @name OXA-data
#'
#' @description
#' A Seurat Object with Oxazolone murine model scRNA-seq data. This disease
#' model shows an Atopic Dermatitis like phenotype in mouse.
#'
#' @usage data(OXA)
#' @docType data
#'
#' @format A matrix object
"OXA"
