% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleSeg.R
\name{simpleSeg}
\alias{simpleSeg}
\title{Perform simple segmentation of multiplexed cellular images}
\usage{
simpleSeg(
  image,
  nucleus,
  cellBody = "dilate",
  sizeSelection = 10,
  smooth = 1,
  transform = NULL,
  watershed = "intensity",
  tolerance = NULL,
  ext = 1,
  discSize = 3,
  tissue = NULL,
  pca = FALSE,
  cores = 1
)
}
\arguments{
\item{image}{An image or list of images or CytoImageList to be read into the
function.}

\item{nucleus}{The marker or list of markers corresponding to the nuclei.}

\item{cellBody}{Method of cytoplasm identification. Can be 'none', dilate',
'discModel' or the name of a dedicated cytoplasm marker}

\item{sizeSelection}{Minimum pixels for an object to be recognized as a cell
and not noise.}

\item{smooth}{The amount of Gaussian smoothing to be applied to the image/s}

\item{transform}{A transformation or list of transformations and
normalizations to be performed prior to nuclei or cytoplasm
identification. Accepted vales: "sqrt", "asinh", "norm99",
"maxThresh" and "tissueMask". Tissue mask may be used when
the sample does not take up the entirety of the image
(typically a circular sample inside the image. When tissue
mask is specified the background noise present outside the
sample area is removed).}

\item{watershed}{Method used to perform watersheding. Accepted values:
"intensity", "distance" or "combine".}

\item{tolerance}{The minimum height of the object in the units of image
intensity between its highest point (seed) and the point
where it contacts another object (checked for every contact
pixel). If the height is smaller than the tolerance, the
object will be combined with one of its neighbors, which is
the highest. Tolerance should be chosen according to the
range of x. Default value is 1, which is a reasonable value
if x comes from distmap.}

\item{ext}{Radius of the neighborhood in pixels for the detection of
neighboring objects. Higher value smooths out small objects.}

\item{discSize}{The size of dilation around nuclei to create cell disc or
capture cytoplasm}

\item{tissue}{Channels to be used to create the tissue mask if specified
in transforms.}

\item{pca}{Whether to run PCA on aggregated nucleus markers in order to
detect the cellular nucclei.}

\item{cores}{The number or cores for parallel processing or a BPPARAM object}
}
\value{
A list of image masks
}
\description{
Perform simple segmentation of multiplexed cellular images
}
\examples{

library(cytomapper)
data("pancreasImages")
masks <- simpleSeg(pancreasImages,
  nucleus = "H3",
  cellBody = "discModel",
  sizeSelection = 8,
  smooth = 1.2,
  transform = "sqrt",
  watershed = "combine",
  tolerance = 1, ext = 1,
  discSize = 3,
  cores = 5
)

}
