% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{dag_circular_viz}
\alias{dag_circular_viz}
\alias{dag_as_DOT}
\alias{dag_graphviz}
\title{Visualize the DAG}
\usage{
dag_circular_viz(
  dag,
  highlight = NULL,
  start = 0,
  end = 360,
  partition_by_level = 1,
  partition_by_size = NULL,
  node_col = NULL,
  node_transparency = 0.4,
  node_size = NULL,
  edge_col = NULL,
  edge_transparency = default_edge_transparency(dag),
  legend_labels_from = NULL,
  legend_labels_max_width = 50,
  other_legends = list(),
  use_raster = dag_n_terms(dag) > 10000,
  newpage = TRUE,
  verbose = simona_opt$verbose
)

dag_as_DOT(
  dag,
  node_param = default_node_param,
  edge_param = default_edge_param,
  rankdir = c("TB", "LR", "BT", "RL")
)

dag_graphviz(
  dag,
  node_param = default_node_param,
  edge_param = default_edge_param,
  rankdir = "TB",
  ...
)
}
\arguments{
\item{dag}{An \code{ontology_Dag} object.}

\item{highlight}{A vector of terms to be highlighted on the DAG.}

\item{start}{Start of the circle, measured in degree.}

\item{end}{End of the circle, measured in degree.}

\item{partition_by_level}{If \code{node_col} is not set, users can cut the DAG into clusters with different node colors. The partitioning is applied by \code{\link[=partition_by_level]{partition_by_level()}}.}

\item{partition_by_size}{Similar as \code{partition_by_level}, but the partitioning is applied by \code{\link[=partition_by_size]{partition_by_size()}}.}

\item{node_col}{Colors of nodes. If the value is a vector, the order should correspond to terms in \code{\link[=dag_all_terms]{dag_all_terms()}}.}

\item{node_transparency}{Transparency of nodes. The same format as \code{node_col}.}

\item{node_size}{Size of nodes. The same format as \code{node_col}.}

\item{edge_col}{A named vector where names correspond to relation types.}

\item{edge_transparency}{A named vector where names correspond to relation types.}

\item{legend_labels_from}{If partitioning is applied on the DAG, a legend is generated showing different top
terms. By default, the legend labels are the term IDs. If there are additionally column stored
in the meta data frame of the DAG object, the column name can be set here to replace the term IDs as
legend labels.}

\item{legend_labels_max_width}{Maximal width of legend labels measured by the number of characters per line. Labels are wrapped into
multiple lines if the widths exceed it.}

\item{other_legends}{A list of legends generated by \code{\link[ComplexHeatmap:Legend]{ComplexHeatmap::Legend()}}.}

\item{use_raster}{Whether to first write the circular image into a temporary png file, then add to the plot
as a raster object?}

\item{newpage}{Whether call \code{\link[grid:grid.newpage]{grid::grid.newpage()}} to create a new plot?}

\item{verbose}{Whether to print messages.}

\item{node_param}{A list of parameters. Each parameter has the same format. The value can be
a single scalar, a full length vector with the same order as in \code{\link[=dag_all_terms]{dag_all_terms()}},
or a named vector that contains a subset of terms that need to be customized.
The full set of parameters can be found at \url{https://graphviz.org/docs/nodes/}.}

\item{edge_param}{A list of parameters. Each parameter has the same format. The value can be a single
scalar, or a named vector that contains a subset of terms that need to be customized.
The full set of parameters can be found at \url{https://graphviz.org/docs/edges/}.
If the parameter is set to a named vector, it can be named by relation types \code{c("is_a" = ...)},
or directly relations \code{c("a -> b" = ...)}. Please see the vignette for details.}

\item{rankdir}{The direction of the layout. Only four values are allowed: \code{"TB"}, \code{"LR"}, \code{"BT"} and \code{"RL"}.}

\item{...}{Pass to \code{\link[DiagrammeR:grViz]{DiagrammeR::grViz()}}.}
}
\value{
\code{dag_as_DOT()} returns a vector of DOT code.
}
\description{
Visualize the DAG
}
\details{
\code{dag_circular_viz()} uses a circular layout for visualizing large DAGs. \code{dag_graphviz()}
uses a hierarchical layout for visualizing small DAGs.

\code{dag_as_DOT()} generates the DOT code of the DAG.

\code{dag_graphviz()} visualizes the DAG with the \strong{DiagrammeR} package.
}
\examples{
\donttest{
dag = create_ontology_DAG_from_GO_db()
dag_circular_viz(dag)
}
1
if(interactive()) {
dag = create_ontology_DAG_from_GO_db()
dag_graphviz(dag[, "GO:0010228"])
dag_graphviz(dag[, "GO:0010228"], 
    edge_param = list(color = c("is_a" = "purple", "part_of" = "darkgreen"),
                      style = c("is_a" = "solid", "part_of" = "dashed")),
    width = 800, height = 800)

# the DOT code for graphviz
dag_as_DOT(dag[, "GO:0010228"])
}
}
\seealso{
\url{http://magjac.com/graphviz-visual-editor/} is nice place to try the DOT code.
}
