% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{dag_filter}
\alias{dag_filter}
\title{Filter the DAG}
\usage{
dag_filter(
  dag,
  terms = NULL,
  relations = NULL,
  root = NULL,
  leaves = NULL,
  mcols_filter = NULL,
  namespace = NULL
)
}
\arguments{
\item{dag}{An \code{ontology_DAG} object.}

\item{terms}{A vector of term names. The sub-DAG will only contain these terms.}

\item{relations}{A vector of relations. The sub-DAG will only contain these relations.
Valid values of "relations" should correspond to the values set in the
\code{relations} argument in the \code{\link[=create_ontology_DAG]{create_ontology_DAG()}}. If \code{relations_DAG} is
already provided, offspring relation types will all be selected. Note "is_a"
is always included.}

\item{root}{A vector of term names which will be used as roots of the sub-DAG. Only
these with their offspring terms will be kept. If there are multiple root terms,
a super root will be automatically added.}

\item{leaves}{A vector of leaf terms. Only these with their ancestor terms will be kept.}

\item{mcols_filter}{Filtering on columns in the meta data frame.}

\item{namespace}{The prefix before ":" of the term IDs.}
}
\value{
An \code{ontology_DAG} object.
}
\description{
Filter the DAG
}
\details{
If the DAG is reduced into several disconnected parts after the filtering, a
super root is automatically added.
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
dag = create_ontology_DAG(parents, children)
dag_filter(dag, terms = c("b", "d", "f"))
dag_filter(dag, root = "b")
dag_filter(dag, leaves = c("c", "b"))
dag_filter(dag, root = "b", leaves = "e")

\donttest{
dag = create_ontology_DAG_from_GO_db()
dag_filter(dag, relations = "is_a")
}
}
