% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\docType{data}
\name{RatioNormalizedIntersect}
\alias{RatioNormalizedIntersect}
\title{RatioNormalizedIntersect class}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
RatioNormalizedIntersect
}
\value{
The \code{RatioNormalizedIntersect$new} function returns a 
\code{RatioNormalizedIntersect} object which contains the information about 
the two profiles. It can be used, as many times 
needed, to calculate the specified metric.
}
\description{
An object which is a interface to calculate the ratio of 
profiles intersection area between two normalized profiles.The profiles are 

The \code{RatioNormalizedIntersect} object is needed to 
calculate the ratio of profiles intersection area between two 
normalized profiles.
A threshold and the two profiles are set during the 
\code{RatioNormalizedIntersect} 
object creation. If different profiles are needed, the 
\code{calculateMetric} function should be used, 
with the new profiles passed as arguments to update those
values inside the \code{RatioNormalizedIntersect} object.

The threshold is the minimum total normalized area value accepted to 
calculate a ratio.
}
\section{Constructor}{

Create a \code{RatioNormalizedIntersect} object.

\code{RatioNormalizedIntersect$new(profile1, profile2, threshold = 1)}

The threshold is the minimum total normalized area value accepted to 
calculate a ratio. Default = 1

The \code{RatioNormalizedIntersect} object inherites those functions:
\itemize{
\item \code{getMetric} { A function that returns the value of the
calculated metric }
\item \code{getInfo} { A function that returns a description of the metric
with the metric value.}
\item \code{getType} { A function that returns the unique name associated
to this metric }
\item \code{calculateMetric} { A function that modifies the values of the
two profiles and the threshold. The new values (profile1, profile2, 
threshold) are passed as arguments.}
}
}

\seealso{
\itemize{
\item \code{\link{MetricFactory}} {for using a interface to calculate all 
available metrics separately or togheter.}
}
}
\author{
Astrid Deschenes
}
\keyword{datasets}
