% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{evaluationSignPlot}
\alias{evaluationSignPlot}
\title{Evaluation Plot}
\usage{
evaluationSignPlot(
  data,
  nametype = "SYMBOL",
  whichSign = NULL,
  whichAssay = "norm_expr",
  sampleAnnot = NULL,
  selectByAnnot = NULL
)
}
\arguments{
\item{data}{an object of type \linkS4class{SummarizedExperiment}. Output of
the signatures functions.}

\item{nametype}{character string saying the type of gene name ID (row names
in data). Either one of "SYMBOL", "ENTREZID" or "ENSEMBL".}

\item{whichSign}{character vector saying the signatures to plot. These must
be signatures computed with signifinder. If not specified, all the
signatures inside data will be plotted.}

\item{whichAssay}{integer scalar or string indicating which assay of
data to use.}

\item{sampleAnnot}{character vector containing samples' annotations.}

\item{selectByAnnot}{character string saying the subgroup from `sampleAnnot`
used to compute the evaluation plot.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
A multipanel plot that shows: (i) a value of the goodness of a signature for
the user's dataset. This is a combination of the parameters shown in the
other pannels; (ii) the percentage of genes from the signature gene list that
are actually available in the dataset; (iii) the percentage of zero values in
the signature genes, for each sample; (iv) the correlation between signature
scores and the sample total read counts; (v) the correlation between
signature scores and the percentage of the sample total zero values.
}
\examples{
data(ovse)
evaluationSignPlot(data = ovse)

}
