% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/feaResult-methods.R,
%   R/gessResult-methods.R
\docType{methods}
\name{result}
\alias{result}
\alias{result,feaResult-method}
\alias{result,gessResult-method}
\title{Method to Extract Result Slots}
\usage{
result(x)

\S4method{result}{feaResult}(x)

\S4method{result}{gessResult}(x)
}
\arguments{
\item{x}{\code{gessResult} or \code{feaResult} object}
}
\value{
tibble
}
\description{
Method extracts \code{tibbles} from \code{result} slots of \code{feaResult} 
and \code{gessResult} objects. They are generated by the GESS and FEA 
functions defined by \code{signatureSearch}, respectively.
}
\examples{
fr <- feaResult(result=dplyr::tibble(id=letters[seq_len(10)], 
                                     val=seq_len(10)),
                organism="human", ontology="MF", drugs=c("d1", "d2"), 
                targets=c("t1","t2"))
result(fr)
gr <- gessResult(result=dplyr::tibble(pert=letters[seq_len(10)], 
                               val=seq_len(10)), 
                 query=list(up=c("g1","g2"), down=c("g3","g4")),
                 gess_method="LINCS", refdb="path/to/lincs/db")
result(gr)
}
