% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{gessResult}
\alias{gessResult}
\title{Constructor for \code{\link{gessResult-class}}}
\usage{
gessResult(result, query, gess_method, refdb)
}
\arguments{
\item{result}{tibble object containing the GESS results}

\item{query}{list or a matrix, query signature}

\item{gess_method}{character(1), name of the GESS method}

\item{refdb}{character(1), path to the reference database}
}
\value{
\code{gessResult} object
}
\description{
This is a helper function to construct a \code{gessResult} object. For 
detail description, please consult the help file of the 
\code{\link{gessResult-class}}.
}
\examples{
gr <- gessResult(result=dplyr::tibble(pert=letters[seq_len(10)], 
                                      val=seq_len(10)), 
                 query=list(up=c("g1","g2"), down=c("g3","g4")),
                 gess_method="LINCS", refdb="path/to/lincs/db")
}
