% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normMedFil.R
\name{normMedFil}
\alias{normMedFil}
\title{Normalization by median filter method}
\usage{
normMedFil(dataMatrix, plateRows, plateCols, dataRows = NULL,
  dataCols = NULL, seqFilter = TRUE)
}
\arguments{
\item{dataMatrix}{Data frame or numeric matrix. Columns are plates, and rows are plate wells.}

\item{plateRows, plateCols}{Number of rows/columns in plate.}

\item{dataRows, dataCols}{Optional integer vector. Indicate which row/column numbers from the dataMatrix should be normalized. If NULL then all rows/columns from the dataMatrix are used.}

\item{seqFilter}{Optional logical. If TRUE apply initial row median filter then standard filter, else just apply standard filter.}
}
\value{
Numeric matrix of normalized data in the same format as dataMatrix
}
\description{
Apply median filter normalization to data
}
\details{
Median Filter normalization uses a two-step median filter process where each well is adjusted by the median score of a neighbouring group of wells [\href{http://www.ncbi.nlm.nih.gov/pubmed/21900202}{Bushway et al (2011)}]. The first median filter uses a neighbour set based on the Manhattan distance to each well. The second median filter uses a neighbour set based on the proximity along each row or column.
}
\note{
For information on how to arrange your dataset for dataMatrix, please see (\code{\link{ex_dataMatrix}})
}
\examples{
## load dataset
data(ex_dataMatrix)

## apply standard median filter method
ex_normMatrix <- normMedFil(dataMatrix = ex_dataMatrix, dataCols = 5:10,
plateRows = 8, plateCols = 10, seqFilter = FALSE)
## apply initial row median filter then standard filter
ex_normMatrix <- normMedFil(dataMatrix = ex_dataMatrix, dataCols = 5:10,
plateRows = 8, plateCols = 10, seqFilter = TRUE)

}
\references{
\href{http://www.ncbi.nlm.nih.gov/pubmed/21900202}{Bushway et al.(2011). Optimization and application of median filter corrections to relieve diverse spatial patterns in microtiter plate data. Journal of Biomolecular Screening, 16(9), 1068-1080.}
}
\seealso{
Other normalization methods: \code{\link{normLoess}},
  \code{\link{normRobZ}}, \code{\link{normR}},
  \code{\link{normSPAWN}}, \code{\link{normZ}}
}

