% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesameAnno.R
\name{sesameAnno_download}
\alias{sesameAnno_download}
\title{Download SeSAMe annotation files}
\usage{
sesameAnno_download(url, destfile = tempfile(basename(url)))
}
\arguments{
\item{url}{url or title of the annotation file}

\item{destfile}{download to this file, a temp file if unspecified}
}
\value{
the path to downloaded file
}
\description{
see also
http://zwdzwd.github.io/InfiniumAnnotation
}
\details{
This function acts similarly as sesameAnno_get except that it directly
download files without invoking BiocFileCache. This is needed in some
situation because BiocFileCache may change the file name and downstream
program may depend on the correct file names. It also lets you download
files in a cleaner way without routing through BiocFileCache
}
\examples{

\dontrun{
## avoid testing as this function uses external host
sesameAnno_download("Test/3999492009_R01C01_Grn.idat")
sesameAnno_download("EPIC.hg38.manifest.tsv.gz")
sesameAnno_download("EPIC.hg38.snp.tsv.gz")
}

}
