% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesameAnno.R
\name{sesameAnno_attachManifest}
\alias{sesameAnno_attachManifest}
\title{Annotate a data.frame using manifest}
\usage{
sesameAnno_attachManifest(
  df,
  probe_id = "Probe_ID",
  platform = NULL,
  genome = NULL
)
}
\arguments{
\item{df}{input data frame with Probe_ID as a column}

\item{probe_id}{the Probe_ID column name, default to "Probe_ID" or
rownames}

\item{platform}{which array platform, guess from probe ID if not given}

\item{genome}{the genome build, use default if not given}
}
\value{
a new data.frame with manifest attached
}
\description{
Annotation source: https://zwdzwd.github.io/InfiniumAnnotation
e.g., EPICv2.hg38.manifest
}
\examples{
\dontrun{
df <- data.frame(Probe_ID = c("cg00101675_BC21", "cg00116289_BC21"))
sesameAnno_attachManifest(df)
}
}
