% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesame.R
\name{getAFTypeIbySumAlleles}
\alias{getAFTypeIbySumAlleles}
\title{Get allele frequency treating type I by summing alleles}
\usage{
getAFTypeIbySumAlleles(sdf, known.ccs.only = TRUE)
}
\arguments{
\item{sdf}{\code{SigDF}}

\item{known.ccs.only}{consider only known CCS probes}
}
\value{
beta values
}
\description{
Takes a \code{SigDF} as input and returns a numeric vector containing
extra allele frequencies based on Color-Channel-Switching (CCS) probes.
If no CCS probes exist in the \code{SigDF}, then an numeric(0) is
returned.
}
\examples{
sesameDataCache() # if not done yet
sdf <- sesameDataGet('EPIC.1.SigDF')
af <- getAFTypeIbySumAlleles(sdf)
}
