% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcf.R
\name{formatVCF}
\alias{formatVCF}
\title{Convert SNP from Infinium array to VCF file}
\usage{
formatVCF(sdf, anno, vcf = NULL, genome = "hg38", verbose = FALSE)
}
\arguments{
\item{sdf}{SigDF}

\item{anno}{SNP variant annotation, available at
https://github.com/zhou-lab/InfiniumAnnotationV1/tree/main/Anno/EPIC
EPIC.hg38.snp.tsv.gz}

\item{vcf}{output VCF file path, if NULL output to console}

\item{genome}{genome}

\item{verbose}{print more messages}
}
\value{
VCF file. If vcf is NULL, a data.frame is output to
console. The data.frame does not contain VCF headers.
Note the output vcf is not sorted.
}
\description{
Convert SNP from Infinium array to VCF file
}
\examples{
sesameDataCacheAll() # if not done yet
sdf <- sesameDataGet('EPIC.1.SigDF')

\dontrun{
## download anno from
## http://zwdzwd.github.io/InfiniumAnnotation
## output to console
anno = read_tsv(sesameAnno_download("EPICv2.hg38.snp.tsv.gz"))
head(formatVCF(sdf, anno))
}

}
