% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnv.R
\name{cnSegmentation}
\alias{cnSegmentation}
\title{Perform copy number segmentation}
\usage{
cnSegmentation(
  sdf,
  sdfs.normal = NULL,
  genomeInfo = NULL,
  probeCoords = NULL,
  tilewidth = 50000,
  verbose = FALSE,
  return.probe.signals = FALSE
)
}
\arguments{
\item{sdf}{\code{SigDF}}

\item{sdfs.normal}{a list of \code{SigDF}s for normalization, if not given,
use the stored normal data from sesameData. However, we do recommend using
a matched copy number normal dataset for normalization.
assembly}

\item{genomeInfo}{the genomeInfo files. The default is retrieved from
sesameData. Alternative genomeInfo files can be found at
https://github.com/zhou-lab/GenomeInfo}

\item{probeCoords}{the probe coordinates in the corresponding genome
if NULL (default), then the default genome assembly is used.
Default genome is given by, e.g., sesameData_check_genome(NULL, "EPIC")
For additional mapping, download the GRanges object from
http://zwdzwd.github.io/InfiniumAnnotation
and provide the following argument
..., probeCoords = sesameAnno_buildManifestGRanges("downloaded_file"),...
to this function.}

\item{tilewidth}{tile width for smoothing}

\item{verbose}{print more messages}

\item{return.probe.signals}{return probe-level instead of bin-level signal}
}
\value{
an object of \code{CNSegment}
}
\description{
Perform copy number segmentation using the signals in the signal set.
The function takes a \code{SigDF} for the target sample and a set of
normal \code{SigDF} for the normal samples. An optional arguments specifies
the version of genome build that the inference will operate on. The function
outputs an object of class \code{CNSegment} with signals for the segments (
seg.signals), the bin coordinates (
bin.coords) and bin signals (bin.signals).
}
\examples{

sesameDataCache()

\dontrun{
sdfs <- sesameDataGet('EPICv2.8.SigDF')
sdf <- sdfs[["K562_206909630040_R01C01"]]
seg <- cnSegmentation(sdf)
seg <- cnSegmentation(sdf, return.probe.signals=TRUE)
visualizeSegments(seg)
}

}
