% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm.R
\name{DML}
\alias{DML}
\title{Test differential methylation on each locus}
\usage{
DML(betas, fm, meta = NULL, BPPARAM = SerialParam())
}
\arguments{
\item{betas}{beta values, matrix or SummarizedExperiment
rows are probes and columns are samples.}

\item{fm}{formula}

\item{meta}{data frame for sample information, column names
are predictor variables (e.g., sex, age, treatment, tumor/normal etc)
and are referenced in formula. Rows are samples.
When the betas argument is a SummarizedExperiment object, this
is ignored. colData(betas) will be used instead. The row order of the
data frame must match the column order of the beta value matrix.}

\item{BPPARAM}{number of cores for parallel processing, default to
SerialParam()
Use MulticoreParam(mc.cores) for parallel processing.
For Windows, try DoparParam or SnowParam.}
}
\value{
a list of test summaries, summary.lm objects
}
\description{
The function takes a beta value matrix with probes on the rows and
samples on the columns. It also takes a sample information data frame
(meta) and formula for testing. The function outputs a list of
coefficient tables for each factor tested.
}
\examples{
sesameDataCache() # in case not done yet
data <- sesameDataGet('HM450.76.TCGA.matched')
smry <- DML(data$betas[1:1000,], ~type, meta=data$sampleInfo)

sesameDataGet_resetEnv()
}
