% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapIntervalSets.R
\name{ssvConsensusIntervalSets}
\alias{ssvConsensusIntervalSets}
\title{Intersect a list of GRanges to create a single GRanges object of merged
ranges including metadata describing overlaps per input GRanges.}
\usage{
ssvConsensusIntervalSets(
  grs,
  ext = 0,
  min_number = 2,
  min_fraction = 0.5,
  preserve_mcols = FALSE,
  ...
)
}
\arguments{
\item{grs}{A list of GRanges}

\item{ext}{An integer specifying how far to extend ranges before merging. in
effect, ranges withing 2*ext of one another will be joined during the merge}

\item{min_number}{An integer number specifying the absloute minimum of input
grs that must overlap for a site to be considered consensus.}

\item{min_fraction}{A numeric between 0 and 1 specifying the fraction of grs
that must overlap to be considered consensus.}

\item{preserve_mcols}{Controls carrying forward mcols metadata from input
list of GRanges. If TRUE, all mcols will be carried forward with the item
name appended. If a character vector, only those attributes will be carried
and all must be present in all GRanges. The default of FALSE will carry
nothing forward and only membership table will be generated.
\link{ssvAnnotateSubjectGRanges} is used internally.}

\item{...}{arguments passed to IRanges::findOverlaps, i.e. maxgap, minoverlap, type, select, invert.}
}
\value{
GRanges with metadata columns describing consensus overlap of input
grs.
}
\description{
In constrast to ssvOverlapIntervalSets, only regions where a consensus of
input grs are present are preserved and annotated.
}
\details{
Only the most stringent of min_number or min_fraction will be
applied.
}
\examples{
library(GenomicRanges)
a = GRanges("chr1", IRanges(1:7*10, 1:7*10))
b = GRanges("chr1", IRanges(5:10*10, 5:10*10))
ssvConsensusIntervalSets(list(a, b))
}
