% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{test_comparison}
\alias{test_comparison}
\title{Overlapping and compared SNVs}
\format{A dataframe with 51 rows and 39 columns:
\describe{
    \item{chr}{chromosome}
    \item{pos}{SNV position}
    \item{DP.sample_1}{total variant depth, sample 1}
    \item{AD1.sample_1}{allelic depth, allele 1, sample 1}
    \item{AD2.sample_1}{allelic depth, allele 2, sample 1}
    \item{A1.sample_1}{allele 1, sample 1}
    \item{A2.sample_1}{allele 2, sample 1}
    \item{warnings.sample_1}{warnings from variant calling, sample 1}
    \item{DP.sample_2}{total variant depth, sample 2}
    \item{AD1.sample_2}{allelic depth, allele 1, sample 2}
    \item{AD2.sample_2}{allelic depth, allele 2, sample 2}
    \item{A1.sample_2}{allele 1, sample 2}
    \item{A2.sample_2}{allele 2, sample 2}
    \item{warnings.sample_2}{warnings from variant calling, sample 2}
    \item{sample_1}{name, sample 1}
    \item{sample_2}{name, sample 2}
    \item{match}{status of genotype comparison}
    \item{rsID}{mutation ID}
    \item{gene}{associated gene}
    \item{ENSGID}{ensembl gene ID}
    \item{ENSTID}{ensembl transcript ID}
    \item{REF}{reference allele}
    \item{ALT}{alternative allele}
    \item{impact}{putative variant impact}
    \item{effect}{variant effect}
    \item{feature}{transcript feature}
    \item{biotype}{transcript biotype}
}}
\usage{
data(test_comparison)
}
\description{
Overlapping and compared variants from "sample1" and "sample2" originating
from the example.vcf file included in the inst/extdata directory, for use in
unit tests.
}
\keyword{datasets}
