% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{learn_model}
\alias{learn_model}
\title{Learn a multi-state model from chromatin data}
\usage{
learn_model(
  inputdir,
  outputdir,
  numstates,
  coordsdir,
  anchorsdir,
  chromsizefile,
  assembly,
  cells,
  annotation,
  binsize,
  inputbamdir,
  cellmarkfiletable,
  read_only = FALSE,
  read_bins = FALSE,
  counts = FALSE
)
}
\arguments{
\item{inputdir}{A string. The path to binarized files.}

\item{outputdir}{A string. The path to a directory where output will be
written.}

\item{numstates}{An integer. The number of desired states in the model.}

\item{coordsdir}{A string. The path to genomic coordinates files.}

\item{anchorsdir}{A string. The path to the genomic anchors files.}

\item{chromsizefile}{A string. The path to the chromosomes sizes file.}

\item{assembly}{A string. The name of the genomic assembely.}

\item{cells}{A \code{character} vector. The names of the cells as they occur
in the binarized files (first line).}

\item{annotation}{A string. The name of the type of annotation as it occurs
in the genomic annotation files.}

\item{binsize}{An integer. The number in bp used to generate binarized files.}

\item{inputbamdir}{A string. The path to the input bam files. Only used when
\code{count = TRUE}.}

\item{cellmarkfiletable}{A string. The path to the input files table. Only
used when \code{bins = TRUE}.}

\item{read_only}{A logical. Default is \code{FALSE}. Whether to look for and
load output files or generate the model from scratch.}

\item{read_bins}{A logical. Default is \code{FALSE}. Whether to load the
binarized data into the output object.}

\item{counts}{A logical. Default is \code{FALSE}. Whether to load the
reads counts in bins data into the output object.}
}
\value{
An object of class \code{\link{segmentation}} (see for details)
and the files written to the output directory.
}
\description{
Integrate multiple ChIP-seq chromatin datasets of histone modifications,
transcription factors or other DNA binding proteins to build a multi-state
model of the combinatorial and spatial frequently occurring patterns.
The function uses as an input binarized ChIP-seq data and the genome
annotations on which the states will be discovered.
}
\details{
By default, this functions runs the analysis commands, writes the
output to files and loads it into an object of class
\code{\link{segmentation}}. In addition, the binarized data and the reads
counts in the bins can be loaded. When \code{read_only} is \code{TRUE}.
The functions looks for previously generated files in the \code{output}
directory and load them without rerunning the commands.
}
\examples{
# locate input and output files
inputdir <- system.file('extdata/SAMPLEDATA_HG18',
                        package = 'segmenter')
outputdir <- tempdir()
coordsdir <- system.file('extdata/COORDS',
                         package = 'chromhmmData')
anchorsdir <- system.file('extdata/ANCHORFILES',
                          package = 'chromhmmData')
chromsizefile <- system.file('extdata/CHROMSIZES',
                             'hg18.txt',
                             package = 'chromhmmData')

# run command
obj <- learn_model(inputdir = inputdir,
                   outputdir = outputdir,
                   coordsdir = coordsdir,
                   anchorsdir = anchorsdir,
                   chromsizefile = chromsizefile,
                   numstates = 3,
                   assembly = 'hg18',
                   cells = c('K562', 'GM12878'),
                   annotation = 'RefSeq',
                   binsize = 200)

# show the output
obj

}
\seealso{
LearnModel
}
