% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meltSE.R
\name{meltSE}
\alias{meltSE}
\title{meltSE}
\usage{
meltSE(
  x,
  features,
  assayName = NULL,
  colDat.columns = NULL,
  rowDat.columns = NULL,
  flatten = TRUE,
  baseDF = TRUE
)
}
\arguments{
\item{x}{An object of class
\code{\link[SummarizedExperiment]{SummarizedExperiment-class}}}

\item{features}{A vector of features (i.e. row.names) to include. Use
`features=NULL` to include all.}

\item{assayName}{The name(s) of the assay(s) to use. If NULL and the assays
are named, all of them will be included.}

\item{colDat.columns}{The colData columns to include (defaults includes all).
Use `colDat.columns=NA` in order not to include any.}

\item{rowDat.columns}{The rowData columns to include (default all). Use
`rowData=NA` to not include any.}

\item{flatten}{Logical, whether to flatten nested data.frames.}

\item{baseDF}{Logical, whether to return a base data.frame (removing columns
containing other objects such as atomic lists). Filtering is applied after
flattening.}
}
\value{
A data.frame (or a DataFrame).
}
\description{
Melts a SE object into a \code{\link[ggplot2]{ggplot}}-ready long data.frame.
}
\examples{
data("Chen2017", package="sechm")
head(meltSE(Chen2017,"Fos"))

}
