% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adt_profiles.R
\name{adtProfiles}
\alias{adtProfiles}
\title{produce a heatmap from a specialized CITE-seq SingleCellExperiment}
\usage{
adtProfiles(x, lb = -3, ub = 3, do_z = FALSE)
}
\arguments{
\item{x}{SingleCellExperiment instance that has an `se.averaged` component
in its metadata}

\item{lb}{numeric(1) lower bound on 'breaks' sequence for ComplexHeatmap::pheatmap, defaults
to -3}

\item{ub}{numeric(1) upper bound on 'breaks' sequence for ComplexHeatmap::pheatmap,
defaults to 3}

\item{do_z}{logical(1) if TRUE, divide the residuals by their standard deviation across clusters,
defaults to false}
}
\value{
ComplexHeatmap::pheatmap instance

side effect of pheatmap::pheatmap call
}
\description{
produce a heatmap from a specialized CITE-seq SingleCellExperiment
}
\note{
See the OSCA book ch12.5.2 for the application.
}
\examples{
ch12sce <- getCh12Sce()
adtProfiles(ch12sce)
adtProfiles(ch12sce, do_z = TRUE)
}
