% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseBarcodeTemplate.R
\name{parseBarcodeTemplate}
\alias{parseBarcodeTemplate}
\title{Parse barcode template}
\usage{
parseBarcodeTemplate(template)
}
\arguments{
\item{template}{String containing template sequence of a barcode.
Variable regions should be marked with N's.}
}
\value{
A list containing:
\itemize{
\item \code{variable}, a \linkS4class{DataFrame} containing the position and length of each run of N's.
\item \code{constant}, a character vector of constant regions flanking and separating the variable regions.
}
}
\description{
Parse a barcode template to identify variable regions based on the run of N's.
}
\details{
The barcode template should contain runs of N's to mark the variable regions.
The first run of N's is the first variable region, the second run of N's is the second variable region, and so on.
The template is \dQuote{realized} into a barcode when the N's are replaced with actual DNA sequence.
The use of a template provides a convenient format to express the general structure of the barcode while avoiding confusion about barcode-specific variable regions.
}
\examples{
# Single spacer:
parseBarcodeTemplate("AAAANNNNNNNGGGG")

# Double spacer:
parseBarcodeTemplate("AAAANNNNCCCCNNGGGG")
}
\author{
Aaron Lun
}
