% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineComboCounts.R
\name{combineComboCounts}
\alias{combineComboCounts}
\title{Combine combinatorial barcode counts}
\usage{
combineComboCounts(...)
}
\arguments{
\item{...}{Any number of \linkS4class{DataFrame}s produced by \code{\link{countComboBarcodes}}.}
}
\value{
A \linkS4class{DataFrame} containing:
\itemize{
\item \code{combinations}, a DataFrame containing all unique combinatorial barcodes observed in any \code{...}.
Each row corresponds to a barcode and each column contains an identifier (either integer or character) for the sequence in the variable region.
\item \code{counts}, a matrix with number of columns equal to number of objects in \code{...}. 
Each row corresponds to a unique combinatorial barcode in \code{keys} and each column represents the count of that barcode in each entry if \code{...}.
Column names are set to the names of \code{...}, if supplied.
}
}
\description{
Combine counts for combinatorial barcodes from multiple files into a single count matrix.
}
\examples{
df1 <- DataFrame(combinations=I(DataFrame(X=1:4, Y=1:4)),
   counts=sample(10, 4))

df2 <- DataFrame(combinations=I(DataFrame(X=1:4, Y=4:1)),
   counts=sample(10, 4))

df3 <- DataFrame(combinations=I(DataFrame(X=1, Y=1)),
   counts=sample(10, 1))

combineComboCounts(df1, df2, df3)

}
\author{
Aaron Lun
}
