% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_runPca.R
\name{runPca.se}
\alias{runPca.se}
\title{Principal components analysis of a Summarizedexperiment}
\usage{
runPca.se(
  x,
  features,
  number = 25,
  block = NULL,
  num.threads = 1,
  more.pca.args = list(),
  assay.type = "logcounts",
  output.name = "PCA",
  meta.name = "PCA",
  delayed.transpose = FALSE
)
}
\arguments{
\item{x}{A \link[SummarizedExperiment]{SummarizedExperiment} object or one of its subclasses.
Rows correspond to genomic features and columns correspond to cells.}

\item{features}{Integer, logical or character vector containing the features of interest to use in the PCA.
For RNA data, this is typically the \code{hvg} vector added by \code{\link{chooseRnaHvgs.se}}.
If \code{NULL}, all available features are used.}

\item{number}{Number of PCs to retain, passed to \code{\link{runPca}}.}

\item{block}{Block assignment for each cell, passed to \code{\link{runPca}}.}

\item{num.threads}{Number of threads for the PCA, passed to \code{\link{runPca}}.}

\item{more.pca.args}{Named list of additional arguments to pass to \code{\link{runPca}}.}

\item{assay.type}{Integer or string specifying the assay of \code{x} to be used for PCA.
This is typically the log-normalized expression matrix created by \code{\link{normalizeRnaCounts.se}}.}

\item{output.name}{String containing the name of the \code{\link[SingleCellExperiment]{reducedDim}} entry in which to store the PC scores.}

\item{meta.name}{String containing the name of the \code{link[S4Vectors]{metadata}} entry in which to store other PCA statistics.}

\item{delayed.transpose}{Logical scalar indicating whether to delay the transposition when storing coordinates in the \code{\link[SingleCellExperiment]{reducedDims}}.}
}
\value{
\code{x} is returned with the principal component scores in the \code{reducedDim}.
(This is converted to a \link[SingleCellExperiment]{SingleCellExperiment} if it wasn't one already.)
Additional outputs (e.g., rotation matrix, variance explained) are stored in the \code{\link[S4Vectors]{metadata}}.
}
\description{
Compact and denoise the dataset by performing PCA on the (log-)normalized expression matrix,
by calling \code{\link{runPca}} on an assay of a \link[SummarizedExperiment]{SummarizedExperiment}.
}
\examples{
library(SingleCellExperiment)
sce <- getTestRnaData.se("hvg")
sce <- runPca.se(sce, rowData(sce)$hvg)
dim(reducedDim(sce, "PCA"))
plot(metadata(sce)$PCA$variance.explained / metadata(sce)$PCA$total.variance)

}
\author{
Aaron Lun
}
