% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_chooseRnaHvgs.R
\name{chooseRnaHvgs.se}
\alias{chooseRnaHvgs.se}
\alias{formatModelGeneVariancesResult}
\title{Choose highly variable genes from a SummarizedExperiment}
\usage{
chooseRnaHvgs.se(
  x,
  block = NULL,
  num.threads = 1,
  more.var.args = list(),
  top = 4000,
  more.choose.args = list(),
  assay.type = "logcounts",
  output.prefix = NULL,
  include.per.block = FALSE
)

formatModelGeneVariancesResult(
  model.res,
  choose.res = NULL,
  include.per.block = FALSE
)
}
\arguments{
\item{x}{A \link[SummarizedExperiment]{SummarizedExperiment} object or one of its subclasses.
Rows correspond to genes and columns correspond to cells.}

\item{block}{Block assignment for each cell, to pass to \code{\link{modelGeneVariances}}.}

\item{num.threads}{Number of threads, to pass to \code{\link{modelGeneVariances}}.}

\item{more.var.args}{Named list of arguments to pass to \code{\link{modelGeneVariances}}.}

\item{top}{Number of HVGs to choose, to pass to \code{\link{chooseHighlyVariableGenes}}.}

\item{more.choose.args}{Named list of arguments to pass to \code{\link{chooseHighlyVariableGenes}}.}

\item{assay.type}{Integer or string specifying the assay of \code{x} containing the log-normalized expression matrix for the RNA data.}

\item{output.prefix}{String containing a prefix to add to the names of the \code{link[SummarizedExperiment]{rowData}} columns containing the output statistics.}

\item{include.per.block}{Logical scalar indicating whether the per-block statistics should be stored in the output \code{rowData}.
Only relevant if \code{block} is specified.}

\item{model.res}{List returned by \code{\link{modelGeneVariances}}.}

\item{choose.res}{Integer vector returned by \code{\link{chooseHighlyVariableGenes}}.
This may be \code{NULL}, in which case the identities of the HVGs will not be stored.}
}
\value{
For \code{chooseRnaHvgs.se}, \code{x} is returned with the per-gene variance modelling statistics added to its \code{rowData}.
The \code{hvg} column in the \code{rowData} indicates whether a gene was chosen as a HVG.
If \code{include.per.block=TRUE} and \code{block} is specified, the per-block statistics are stored as a nested DataFrame in the \code{per.block} column.

For \code{formatModelGeneVariancesResult}, a \link[S4Vectors]{DataFrame} is returned with the per-gene variance modelling statistics.
If \code{choose.res} is provided, a \code{hvg} column is also stored that indicates whether a gene was chosen as a HVG.
}
\description{
Model the mean-variance relationship across genes and choose highly variable genes (HVGs) based on the residuals of the fitted trend.
This calls \code{\link{modelGeneVariances}} on an assay of a \link[SummarizedExperiment]{SummarizedExperiment},
and then calls \code{\link{chooseHighlyVariableGenes}} on the residuals.
}
\examples{
library(SingleCellExperiment)
sce <- getTestRnaData.se("norm")
sce <- chooseRnaHvgs.se(sce, more.var.args=list(use.min.width=TRUE))
summary(rowData(sce)$hvg)

plot(rowData(sce)$means, rowData(sce)$variances, col=factor(rowData(sce)$hvg))
curve(approxfun(rowData(sce)$means, rowData(sce)$fitted)(x), col="dodgerblue", add=TRUE)

}
\author{
Aaron Lun
}
