% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSCP.R
\name{readSCP}
\alias{readSCP}
\alias{readSCPfromDIANN}
\alias{readSingleCellExperiment}
\title{Read single-cell proteomics tabular data}
\usage{
readSCP(..., experimentsAsSce = FALSE)

readSCPfromDIANN(..., experimentsAsSce = FALSE)

readSingleCellExperiment(...)
}
\arguments{
\item{...}{Parameters passed to \code{\link[=readSummarizedExperiment]{readSummarizedExperiment()}},
\code{\link[=readQFeatures]{readQFeatures()}} or \code{\link[=readQFeaturesFromDIANN]{readQFeaturesFromDIANN()}}. See these
respective manual pages for details.}

\item{experimentsAsSce}{A \code{logical(1)} indicating whether the
\code{QFeatures} object should be composed of \code{SingleCellExperiment}
objects. By default: \code{FALSE}, the \code{QFeatures} object will be composed
of \code{SummarizedExperiment} objects. Note that using
\code{SingleCellExperiment} can impact the performance.}
}
\value{
An instance of class \code{SingleCellExperiment} or a
\code{QFeatures}, composed of \code{SingleCellExperiment} or
\code{SummarizedExperiment} objects.
}
\description{
Function to import and convert tabular data from a spreadsheet or
a \code{data.frame} into a \code{SingleCellExperiment} and \code{QFeatures}
object.
}
\note{
The \code{SingleCellExperiment} class is built on top of the
\code{RangedSummarizedExperiment} class. This means that some column names
are forbidden in the \code{rowData}. Avoid using the following names:
\code{seqnames}, \code{ranges}, \code{strand}, \code{start}, \code{end},
\code{width},  \code{element}
}
\examples{

######################################################
## Load a single acquisition as a SingleCellExperiment

## Load a data.frame with PSM-level data
data("mqScpData")

## Create the QFeatures object
quantCols <- grep("Reporter.intensity.\\\\d", colnames(mqScpData))
sce <- readSingleCellExperiment(mqScpData, quantCols)
sce

######################################################
## Load multiple acquisitions as a QFeatures

## Load an example table containing MaxQuant output
data("mqScpData")

## Load the (user-generated) annotation table
data("sampleAnnotation")

## Format the tables into a QFeatures object
readSCP(assayData = mqScpData,
        colData = sampleAnnotation,
        runCol = "Raw.file")
}
\seealso{
\itemize{
\item The more general \code{\link[QFeatures:readQFeatures]{QFeatures::readQFeatures()}} function, which
this function depends on.
\item The more general \code{\link[QFeatures:readQFeaturesFromDIANN]{QFeatures::readQFeaturesFromDIANN()}} function,
for details and an example on how to read label-free and plexDIA
(mTRAQ) data processed with DIA-NN.
\item The \code{\link[QFeatures:readQFeatures]{QFeatures::readSummarizedExperiment()}} function, which
\code{readSingleCellExperiment()} depends on.
\item The \code{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment()}} class.
}
}
