% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreInvHap-package.R, R/scoreInvHap.R
\docType{package}
\name{scoreInvHap}
\alias{scoreInvHap}
\title{scoreInvHap: package to get inversion status of predefined regions.}
\usage{
scoreInvHap(
  SNPlist,
  inv = NULL,
  SNPsR2,
  hetRefs,
  Refs,
  R2 = 0,
  probs = FALSE,
  BPPARAM = BiocParallel::SerialParam(),
  verbose = FALSE
)
}
\arguments{
\item{SNPlist}{List with SNPs data from plink or \code{VCF-class}.}

\item{inv}{Character with the name of the inversion to genotype. The available
inversions are included in a table in the main vignette.}

\item{SNPsR2}{Vector with the R2 of the SNPs of the region}

\item{hetRefs}{Vector with the heterozygote form of the SNP in the inversion}

\item{Refs}{List with the allele frequencies in the references}

\item{R2}{Vector with the R2 between the SNPs and the inversion status}

\item{probs}{Logical. If TRUE, scores are computed using posterior probabilities.
If FALSE, scores are computed using best guess. Only applied when SNPlist is a VCF.}

\item{BPPARAM}{A \code{BiocParallelParam} instance. Used to parallelize computation}

\item{verbose}{Should message be shown?}
}
\value{
A \code{scoreInvHap} object
}
\description{
scoreInvHap can get the samples' inversion status of known inversions. scoreInvHap uses SNP data as input
and requires the following information about the inversion: genotype frequencies in the different
inversion groups, R2 between the region SNPs and inversion status, heterozygote genotypes in the
reference, allele frequencies in the reference population and inversion frequencies.
The package include this data for 21 inversions.

This is the main function of `scoreInvHap` package. This function accepts
SNPs data in a plink or a VCF format and compute the inversion prediction. The list
of available inversions is included in a GenomicRanges called `inversionGR`.
}
\examples{

# See list of inversions
data(inversionGR)
inversionGR

## Run method
if(require(VariantAnnotation)){
    vcf <- readVcf(system.file("extdata", "example.vcf", package = "scoreInvHap"), "hg19")
    res <- scoreInvHap(vcf, inv = "inv7_005")
}


}
