% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scde.fit.models.to.reference}
\alias{scde.fit.models.to.reference}
\title{Fit scde models relative to provided set of expression magnitudes}
\usage{
scde.fit.models.to.reference(counts, reference, n.cores = 10,
  zero.count.threshold = 1, nrep = 1, save.plots = FALSE,
  plot.filename = "reference.model.fits.pdf", verbose = 0, min.fpm = 1)
}
\arguments{
\item{counts}{count matrix}

\item{reference}{a vector of expression magnitudes (read counts) corresponding to the rows of the count matrix}

\item{n.cores}{number of cores to use}

\item{zero.count.threshold}{read count to use as an initial guess for the zero threshold}

\item{nrep}{number independent of mixture fit iterations to try (default = 1)}

\item{save.plots}{whether to write out a pdf file showing the model fits}

\item{plot.filename}{model fit pdf filename}

\item{verbose}{verbose level}

\item{min.fpm}{minimum reference fpm of genes that will be used to fit the models (defaults to 1). Note: fpm is calculated from the reference count vector as reference/sum(reference)*1e6}
}
\value{
matrix of scde models
}
\description{
If group-average expression magnitudes are available (e.g. from bulk measurement), this method can be used
to fit individual cell error models relative to that reference
}
\examples{
data(es.mef.small)
cd <- clean.counts(es.mef.small, min.lib.size=1000, min.reads = 1, min.detected = 1)
\donttest{
o.ifm <- scde.error.models(counts = cd, groups = sg, n.cores = 10, threshold.segmentation = TRUE)
o.prior <- scde.expression.prior(models = o.ifm, counts = cd, length.out = 400, show.plot = FALSE)
# calculate joint posteriors across all cells
jp <- scde.posteriors(models = o.ifm, cd, o.prior, n.cores = 10, return.individual.posterior.modes = TRUE, n.randomizations = 100)
# use expected expression magnitude for each gene
av.mag <- as.numeric(jp$jp \%*\% as.numeric(colnames(jp$jp)))
# translate into counts
av.mag.counts <- as.integer(round(av.mag))
# now, fit alternative models using av.mag as a reference (normally this would correspond to bulk RNA expression magnitude)
ref.models <- scde.fit.models.to.reference(cd, av.mag.counts, n.cores = 1)
}

}

